 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/

 #ifndef __BSQUEUE4_H
 #define __BSQUEUE4_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class BSQueue4 : public Atomic
 {
   public:
	       BSQueue4( const std::string &name = "BSQueue4" );	//Default constructor
	       virtual std::string className() const { return "BSQueue4"; }
	       ~BSQueue4();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &IB0,&IB1,&IB2,&IB3,&IB5,&IB6,&IU2,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class BSQueue4

 #endif   //__BSQUEUE4_H
